<?php require_once("inc/header.php"); ?>
<div class="page-content container container-plus">
  <div class="card acard mt-2 mt-lg-3">
    <div class="card-header">
      <h3 class="card-title text-125 text-primary-d2">
        <i class="far fa-edit text-dark-l3 mr-1"></i>
        View Products
      </h3>
    </div>

    <div class="card-body px-3 pb-1">

      <table id="myTable" class="display" style="width:100%">
        <thead>
          <tr>
            <th>#</th>
            <th>Image</th>
            <th>Category</th>
            <th>Name</th>
            <th>Description</th>
            <th>Price</th>
            <th>Estimated Time</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>

          <?php
          $sql = "SELECT p.*, c.name AS category_name 
              FROM products p 
              JOIN categories c ON p.category_id = c.id 
              ORDER BY p.id DESC";
          $result = $conn->query($sql);
          $i = 1;
          while ($row = $result->fetch_assoc()):
          ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><img src="uploads/products/<?= htmlspecialchars($row['image']) ?>" class="thumb"></td>
              <td><?= htmlspecialchars($row['category_name']) ?></td>
              <td><?= htmlspecialchars($row['name']) ?></td>
              <td><?= htmlspecialchars($row['description']) ?></td>
              <td><?= number_format($row['price'], 2) ?></td>
              <td><?= htmlspecialchars($row['est_time']) ?></td>
              <td>
                <a href="edit-product.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-primary">Edit</a>
                <button class="btn btn-sm btn-danger deleteBtn" data-id="<?= $row['id'] ?>">Delete</button>
              </td>
            </tr>
          <?php endwhile; ?>

        </tbody>
      </table>


    </div><!-- /.card-body -->
  </div><!-- /.card -->


</div>
<?php require_once("inc/footer.php"); ?>

<script>
  $(document).ready(function() {


  });
</script>